<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Configuration extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'description',
        'type', // text, boolean, number, json, file, file (image), etc.
        'group', // For grouping configurations (e.g., 'general', 'forum', 'payment')
    ];
    
    /**
     * Get the configuration value with proper casting based on type.
     *
     * @return mixed
     */
    public function getTypedValueAttribute()
    {
        switch ($this->type) {
            case 'boolean':
                return (bool) $this->value;
            case 'number':
                return (float) $this->value;
            case 'json':
                return json_decode($this->value, true);
            case 'file':
            case 'image':
                return $this->value;
            default:
                return $this->value;
        }
    }
}